<?php 

require_once __DIR__.'/Connection.php';
include_once __DIR__.'/Crud.php';

class Guests extends Connection implements Crud
{

    public  $id = null ;

    public function __construct(){
        parent::establishConnection();
    }

    public function select($id = null)
    {
        if(is_null($id)):
            $query = $this->conector->prepare('SELECT * FROM guests');
            $query->execute();
        else:
            $query = $this->conector->prepare('SELECT * FROM guests WHERE id = ?');
            $query->execute([$id]);
        endif;
        return $query->fetchAll(PDO::FETCH_OBJ);
    }

    public function update($params , $id)
    {
        try{
            $sets = [];
            foreach($params as $key => $value):
                $sets[] =  $key .' = :'.$key;
            endforeach;
            $sql = 'UPDATE guests SET '. implode(',' , $sets) . ' WHERE id = :id';
            $query = $this->conector->prepare($sql);
            foreach($params as $column => $value):
                $column = str_replace('"','',$column);
                $query->bindValue(":{$column}", $value);
            endforeach;
            $query->bindParam(':id',$id);
            return $query->execute();
        }catch (\Throwable $th) {
            return FALSE;
        }
    }

    public function insert($params)
    {
        $params['active'] = 1;
        $params['"table"'] = 0;
        try {
            $pdoparams = str_replace('"','',implode(",:", array_keys($params)));
            $sql = 'INSERT INTO guests ('.implode(",", array_keys($params)) .') VALUES (:'.$pdoparams .')';
            $query = $this->conector->prepare($sql);
            foreach($params as $column => $value):
                $column = str_replace('"','',$column);
                $query->bindValue(":{$column}", $value);
            endforeach;
            return is_numeric( (int) $query->execute()) ? TRUE : FALSE; 
        } catch (\Throwable $th) {
            return FALSE;
        }
     
    }

    public function delete($params){
        try {
            
            if( count($params) == 1):
                $id = $params[0];
                $query = $this->conector->prepare("DELETE FROM guests WHERE id = :id");
                $query->bindParam(':id', $id);
            else:
                $ids = implode(",", $params);
                $query = $this->conector->prepare("DELETE FROM guests WHERE id IN ({$ids})");
            endif;
            return $query->execute();
        } catch(PDOException $e) {
            return FALSE;
        }
    }

    public function getTodoGuests($confirm = null){

        $sql = "SELECT id,name,email ,quantity invitados , confirmation confirmados,message
                FROM guests ";
        if(!is_null($confirm)):
            if(is_bool($confirm) AND $confirm):
                $sql .= "WHERE qrcode IS NOT NULL AND qrcode != ''";
            else:
                $sql .= "WHERE qrcode IS NULL";
            endif;
        endif;
        $query = $this->conector->prepare($sql);
        $query->execute();
        return $query->fetchAll(PDO::FETCH_OBJ);
    }

    public static function encrypt ($string) {
        return base64_encode(base64_encode($string));
    }

    public static function decrypt ($string) {
        return base64_decode(base64_decode($string));
    }

}