<?php 
  include_once __DIR__ .'/api/Constants.php';
  require_once __DIR__.'/api/models/Guests.php';
  $guest = new Guests();
  $data = $guest->select($guest::decrypt($_GET['code']??0))[0];
  $dateEvent = '14 Septiembre 2024';
?>
  <!DOCTYPE html>
    <html lang="es-Mx">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="initial-scale=1, maximum-scale=1">
        <meta property="og:image" content="<?=BASE_URL?>assets/imgs/card_social.png" />
        <meta property="og:image:width" content="1200" />
        <meta property="og:image:height" content="628" />
        <meta property="og:title" content="Tercer Informe de Gobierno"/>
        <meta property="og:url" content="https://celaya.gob.mx"/>
        <meta property="og:description" content="El Ayuntamiento y el Gobierno Municipal de calaya te invitan al tercer informe de resultados" />
        <meta name="description" content="El Ayuntamiento y el Gobierno Municipal de calaya te invitan al tercer informe de resultado" />
        <link rel="icon" type="image/jpg" href="<?=BASE_URL?>assets/imgs/favicon.ico"/>
        <meta name="author" content="junglaCODE">
        <meta name="robots" content="noindex">
        <title>Tercer Informe de Gobierno en Celaya </title>
        <link rel="stylesheet" href="<?=BASE_URL?>assets/css/reset.css?ver=<?=VERSION?>">
        <link rel="stylesheet" href="<?=BASE_URL?>assets/css/style.css?ver=<?=VERSION?>">
        <link rel="stylesheet" href="<?=BASE_URL?>assets/css/desing.css?ver=<?=VERSION?>">
        <link rel="stylesheet" href="<?=BASE_URL?>assets/css/owl.carousel.min.css?ver=<?=VERSION?>">
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css" />
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" integrity="sha512-iecdLmaskl7CVkqkXNQ/ZH/XLlvWZOJyj7Yy7tcenmpD1ypASozpmT/E0iPtmFIB46ZmdtAc9eNBvH0H/ZpiBw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
        <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
        <script>
            var timerBienvenida = 2000;
        </script>
     </head>
    <body>
    <div class="modal-bienvenida">
        <div class="modal-bienvenida-body">
            <span class="loader">Mitotl</span>
            <span class="loader-box"></span>
        </div>
    </div>
    <div class="main-container">
        <section id="intro" class="intro hg-75">
            <img src="<?=BASE_URL?>assets/imgs/intro.png"  alt="intro" class="bg-intro">
            <div class="into-name">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-3 col-sm-1"></div>
                        <div class="col-lg-6 col-sm-10">
                            <img class="img-fluid animate__animated animate__fadeInDownBig animate__delay-3s" src="<?=BASE_URL?>assets/imgs/text.png" alt="texto informativo">
                            <img class="img-fluid animate__animated animate__fadeInDownBig animate__delay-3s" src="<?=BASE_URL?>assets/imgs/people.png" alt="Gente celayense">
                        </div> 
                        <div class="col-lg-3 col-sm-1"></div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Contador -->
        <section  class="Contador animate__animated animate__headShake">   
            <div class="container">
                <div class="row">
                    <div class="col-lg-3 col-sm-1"></div>
                    <div id="text2" class="col-lg-6 col-sm-10">
                        <img class="img-fluid animate__animated animate__fadeInDownBig animate__delay-3s ml-2" src="<?=BASE_URL?>assets/imgs/text-2.png" alt="gracias a ti">
                    </div>
                    <div class="col-lg-3 col-sm-1"></div>
                </div>
                <div class="row">
                    <div class="col-lg-3 col-sm-1"></div>
                    <div class="col-lg-6 col-sm-10">
                        <h3 data-aos="fade-up" data-aos-anchor-placement="bottom-bottom" data-aos-duration="2000"
                                style="font-weight: lighter;">
                            Nos Honrará contar con la presencia del Gobernador Constitucional del Estado de Guanajuato
                        </h3>  
                        <h3 data-aos="fade-up" data-aos-anchor-placement="bottom-bottom" data-aos-duration="2000">
                            Diego Sinhue Rodríguez Vallejo
                        </h3>      
                        <br>        
                        <h4 data-aos="fade-up"  data-aos-anchor-placement="bottom-bottom" data-aos-duration="2000" style="text-align: center; font-weight: lighter;">
                            MIÉRCOLES 4 DE SEPTIEMBRE 
                            12:00 PM
                            TEATRO DE LA CIUDAD
                        </h4>
                    </div>
                    <div class="col-lg-3 col-sm-1"></div>
                </div>
                <div class="row">
                    <div class="col-lg-3 col-sm-1"></div>
                    <div class="col-lg-6 col-sm-10">
                    <form id="deseos" class="form-reservacion"  onsubmit="return app.enviarConfirmacion(event)" data-aos="fade-up" data-aos-anchor-placement="bottom-bottom" data-aos-duration="2000">
                        <div class="wrap-send">
                            <div class="enviando">
                                <div class="box">
                                    <div class="border one"></div>
                                    <div class="border two"></div>
                                    <div class="border three"></div>
                                    <div class="border four"></div>
                                    <div class="line one"></div>
                                    <div class="line two"></div>
                                    <div class="line three"></div>
                                </div>
                            </div>
                        </div>               
                        <h3 style="color:black">Confirma tu asistencia</h3>
                        <div class="row" style="display:none;">
                            <input type="text"  class="usr-nombre" name="usr-nombre" readonly>    
                            <input type="email" class="usr-correo" name="user_email" readonly>   
                            <input type="text"  class="zone" name="zone" readonly>           
                        </div>
                        <div class="row">
                            <select name="" required id="invitados" class="num-invitados">
                                <option value="1"  selected>Si asisteré</option>
                                <option value="0"  selected>No asisteré</option>
                            </select>
                        </div>
                        <div class="row">
                            <button type="submit" class="btn-grl">Confirmar</button>
                        </div>
                    </form>
                    <div class="row mt-3">
                    <div id="_contador" class="wrapper mb-3">
                    <div>
                    </div>
                    <div class="display"  data-aos="fade-up-right" data-aos-duration="2000">
                        <span class="day"></span> <br>
                        <label>Días</label>
                    </div>
                    <div class="display"  data-aos="fade-up-left" data-aos-duration="2000">
                        <span class="hours"></span><br>
                        <label>Horas</label>
                    </div>
                    <div class="display"  data-aos="fade-down-right" data-aos-duration="2000">
                        <span class="minutes"></span><br>
                        <label>Minutos</label>
                    </div>
                    <div class="display"  data-aos="fade-down-left" data-aos-duration="2000">
                        <span class="seconds"></span><br>
                        <label>Segundos</label>
                    </div>
                    <div>
                </div>
                    </div>
                </div>
                    <div class="col-lg-3 col-sm-1"></div>
                    
                </div>
            </div>
        </section>   
        <div class="modal-container">
            <div class="modal-lateral-nombres">Invitaciones Mitotl1</div>
            <button class="cerrar-modal" onclick="app.cerrarModal()"></button>
            <div class="modal-wrap"><div class="wrap-info-modal"><h3>Disculpa las molestias</h3><p>No podemos encontrar tu invitación, por favor contacta al administrador del evento.</p></div>
            </div>
        </div>   
    </div>
    <footer>
        <a target="_blank" href="https://junglacode.org">Invitaciones Mitotl | Powered by ♥ junglaCODE</a>
    </footer>
    </div>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/2.1.3/jquery.min.js"></script>
    <script src="https://rawgithub.com/markdalgleish/stellar.js/master/jquery.stellar.min.js"></script>
    <script src="<?=BASE_URL?>assets/js/owl.carousel.min.js"></script>
    <script src="<?=BASE_URL?>assets/js/skrollr.js"></script>
    <script src="<?=BASE_URL?>assets/js/countdown.js"></script>
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <script>
        var invitados = <?= json_encode($data)?>;
        var token = "<?=$_GET['code']?>";
        countdown(new Date("<?= $dateEvent ?>"));
        AOS.init();
    </script>
    <script src="<?=BASE_URL?>assets/js/app.js?ver=<?=VERSION?>"></script>   
    </body>
    </html>